<?php
/**
 * Plugin Name: Clock plugin
 * Plugin URI: https://it-breeze.info/
 * Update URI: https://it-breeze.cloud/data/clock/clock.json
 * Description:  A plugin to have analog and digital clocks in posts and pages, colours and timeyone can be parsed as arguments
 * Version: 1.4.0
 * Author: Mike Vahldieck
 * Author URI: https://it-breeze.info/
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
  * Requires at least: 5.8
 * Requires PHP: 7.4
 */
if (!defined('ABSPATH')) exit;

function clock_register_settings() {
    add_option('clock_background_color', '#ffffff');
    add_option('clock_hands_color', '#000000');
    add_option('clock_seconds_color', '#ff0000');
    add_option('clock_digital_color', '#000000');
    add_option('clock_timezone_color', '#000000');
    add_option('clock_border_color', '#000000');
    add_option('clock_numbers_color', '#000000');

    register_setting('clock_options_group', 'clock_background_color');
    register_setting('clock_options_group', 'clock_hands_color');
    register_setting('clock_options_group', 'clock_seconds_color');
    register_setting('clock_options_group', 'clock_digital_color');
    register_setting('clock_options_group', 'clock_timezone_color');
    register_setting('clock_options_group', 'clock_border_color');
    register_setting('clock_options_group', 'clock_numbers_color');
}
add_action('admin_init', 'clock_register_settings');

function clock_register_options_page() {
    add_options_page(
        'Clock Settings',
        'Clock',
        'manage_options',
        'clock',
        'clock_options_page'
    );
}
add_action('admin_menu', 'clock_register_options_page');

function clock_options_page() {
    ?>
    <div class="wrap">
        <h1>Clock Settings</h1>
        <form method="post" action="options.php">
            <?php settings_fields('clock_options_group'); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Clock Background Color</th>
                    <td><input type="color" name="clock_background_color" value="<?php echo esc_attr(get_option('clock_background_color')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Hour/Minute Hands Color</th>
                    <td><input type="color" name="clock_hands_color" value="<?php echo esc_attr(get_option('clock_hands_color')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Second Hand Color</th>
                    <td><input type="color" name="clock_seconds_color" value="<?php echo esc_attr(get_option('clock_seconds_color')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Digital Clock Text Color</th>
                    <td><input type="color" name="clock_digital_color" value="<?php echo esc_attr(get_option('clock_digital_color')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Timezone Text Color</th>
                    <td><input type="color" name="clock_timezone_color" value="<?php echo esc_attr(get_option('clock_timezone_color')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Clock Border Color</th>
                    <td><input type="color" name="clock_border_color" value="<?php echo esc_attr(get_option('clock_border_color')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Clock Numbers Color</th>
                    <td><input type="color" name="clock_numbers_color" value="<?php echo esc_attr(get_option('clock_numbers_color')); ?>" /></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

function display_analog_digital_clocks($atts) {
    static $instance_id = 0;
    $instance_id++;

    $zones = shortcode_atts([
        'locations' => 'GMT,Europe/Berlin,America/New_York,Asia/Bangkok,Asia/Makassar',
        'background' => '',
        'hands'      => '',
        'seconds'    => '',
        'digital'    => '',
        'timezone'   => '',
        'border'     => '',
        'numbers'    => '',
    ], $atts);

    $locations = array_map('trim', explode(',', $zones['locations']));

    $output  = '<div id="analog-clocks-' . (int)$instance_id . '" class="analog-clocks">';
    foreach ($locations as $location) {
        $id = strtolower(str_replace(['/', ' '], '-', $location)) . '-' . $instance_id;
        $output .= '
        <div class="city-clock" style="display:inline-block;margin:8px;text-align:center;">
            <canvas id="' . esc_attr($id) . '-clock" width="150" height="150"></canvas>
            <div style="text-align:center;">
                <span id="' . esc_attr($id) . '-digital" class="digital-time"></span><br>
                <span id="' . esc_attr($id) . '-label" class="timezone-label">' . esc_html($location) . '</span>
            </div>
        </div>';
    }
    $output .= '</div>';

    wp_enqueue_script('clock-script', plugins_url('clock.js', __FILE__), [], false, true);
    wp_enqueue_style('clock-style', plugins_url('clock.css', __FILE__));

    $settings = [
        'background' => $zones['background'] ?: get_option('clock_background_color', '#ffffff'),
        'hands'      => $zones['hands']      ?: get_option('clock_hands_color', '#000000'),
        'seconds'    => $zones['seconds']    ?: get_option('clock_seconds_color', '#ff0000'),
        'digital'    => $zones['digital']    ?: get_option('clock_digital_color', '#000000'),
        'timezone'   => $zones['timezone']   ?: get_option('clock_timezone_color', '#000000'),
        'border'     => $zones['border']     ?: get_option('clock_border_color', '#000000'),
        'numbers'    => $zones['numbers']    ?: get_option('clock_numbers_color', '#000000'),
    ];

    $unique_var = 'clockData_' . $instance_id;
    $clock_data = [
        'locations' => $locations,
        'settings'  => $settings,
    ];

    wp_localize_script('clock-script', $unique_var, $clock_data);

    $init = "window.clockInitQueue = window.clockInitQueue || [];
window.clockInitQueue.push({varName: '" . esc_js($unique_var) . "', instanceId: '" . (int)$instance_id . "'});";
    wp_add_inline_script('clock-script', $init);

    return $output;
}
add_shortcode('clock', 'display_analog_digital_clocks');

require_once plugin_dir_path(__FILE__) . 'update.php';
new clock_Plugin_Updater(__FILE__, 'clock', 'https://it-breeze.cloud/data/clock/clock.json');
