jQuery(document).ready(function($) {
    // Check if cookie consent banner should be shown
    if (!getCookie('cookie_consent')) {
        $('#cookie-consent-banner').fadeIn();
    }
    
    // Handle accept button click
    $('#cookie-consent-accept').on('click', function(e) {
        e.preventDefault();
        handleCookieChoice('accept');
    });
    
    // Handle decline button click
    $('#cookie-consent-decline').on('click', function(e) {
        e.preventDefault();
        handleCookieChoice('decline');
    });
    
    function handleCookieChoice(choice) {
        $.ajax({
            url: cookieConsent.ajax_url,
            type: 'POST',
            data: {
                action: 'accept_cookies',
                action_type: choice,
                nonce: cookieConsent.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#cookie-consent-banner').fadeOut();
                    
                    // If user accepted, you can enable tracking scripts here
                    if (choice === 'accept') {
                        enableTrackingScripts();
                    }
                }
            },
            error: function() {
                console.log('Error processing cookie consent');
            }
        });
    }
    
    function enableTrackingScripts() {
        // Add your tracking scripts here when cookies are accepted
        // Example:
        // Google Analytics
        // Facebook Pixel
        // Other tracking codes
        
        console.log('Cookies accepted - tracking scripts can be enabled');
        
        // Trigger custom event for other scripts to listen to
        $(document).trigger('cookiesAccepted');
    }
    
    function getCookie(name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for(var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    }
});