jQuery(document).ready(function($) {
    var mediaUploader;

    function setupMediaUploader(buttonSelector, inputSelector, previewSelector, removeButtonSelector) {
        $(buttonSelector).click(function(e) {
            e.preventDefault();
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            mediaUploader = wp.media.frames.file_frame = wp.media({
                title: 'Choose Image',
                button: {
                    text: 'Choose Image'
                },
                multiple: false
            });
            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                $(inputSelector).val(attachment.url);
                $(previewSelector).html('<img src="' + attachment.url + '" style="max-width: 100px; margin: 5px;">');
                $(removeButtonSelector).show();
            });
            mediaUploader.open();
        });

        $(removeButtonSelector).click(function(e) {
            e.preventDefault();
            $(inputSelector).val('');
            $(previewSelector).empty();
            $(this).hide();
        });

        var initialImageUrl = $(inputSelector).val();
        if (initialImageUrl) {
            $(previewSelector).html('<img src="' + initialImageUrl + '" style="max-width: 100px; margin: 5px;">');
            $(removeButtonSelector).show();
        }
    }

    // Setup for background image
    setupMediaUploader(
        '#maintenance_mode_background_image_button',
        '#maintenance_mode_background_image',
        '#maintenance_mode_background_image_preview',
        '#maintenance_mode_background_image_remove'
    );

    // Setup for message image
    setupMediaUploader(
        '#maintenance_mode_message_image_button',
        '#maintenance_mode_message_image',
        '#maintenance_mode_message_image_preview',
        '#maintenance_mode_message_image_remove'
    );
});
