#!/bin/bash
# Auto-save with semantic versioning (vX.Y.Z)
cd "$(dirname "$0")"

# get last version tag (e.g. v1.0.5)
latest_tag=$(git describe --tags --abbrev=0 2>/dev/null)

# if no tags yet, start at v1.0.0
if [ -z "$latest_tag" ]; then
    latest_tag="v1.0.0"
fi

# extract numbers
ver="${latest_tag#v}"
IFS='.' read -r major minor patch <<< "$ver"

# increment patch version
patch=$((patch + 1))
new_tag="v${major}.${minor}.${patch}"

# only commit if there are changes
if ! git diff --quiet; then
    git add -A
    msg="Auto-save: $(date '+%Y-%m-%d %H:%M:%S')"
    git commit -m "$msg" >/dev/null 2>&1
    git tag -a "$new_tag" -m "Auto-version $new_tag"
    echo "Auto-saved and tagged $new_tag at $(date)"
fi
