jQuery(document).ready(function($) {
    var searchTimeout;
    
    
    $('#song-search').on('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function() {
            filterSongs();
        }, 500);
    });
    
    
    $('#genre-filter, #year-filter, #language-filter').on('change', function() {
        filterSongs();
    });
    
    function filterSongs() {
        var search = $('#song-search').val();
        var genre = $('#genre-filter').val();
        var year = $('#year-filter').val();
        var language = $('#language-filter').val();
        
        
        $('#loading-indicator').show();
        $('#song-cards-container').addClass('loading');
        
        $.ajax({
            url: song_manager_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'filter_songs',
                search: search,
                genre: genre,
                year: year,
                language: language,
                nonce: song_manager_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#song-cards-container').html(response.data);
                } else {
                    $('#song-cards-container').html('<p>Fehler beim Laden der Songs.</p>');
                }
            },
            error: function() {
                $('#song-cards-container').html('<p>Fehler beim Laden der Songs.</p>');
            },
            complete: function() {
                $('#loading-indicator').hide();
                $('#song-cards-container').removeClass('loading');
            }
        });
    }
    
    
    initializeAudioPlayers();
    
    
    $(document).on('DOMSubtreeModified', '#song-cards-container', function() {
        initializeAudioPlayers();
    });
    
    function initializeAudioPlayers() {
        
        $('audio').each(function() {
            
        });
    }
    
    
    $('a[href*="#"]').on('click', function(e) {
        var target = $(this.getAttribute('href'));
        if (target.length) {
            e.preventDefault();
            $('html, body').stop().animate({
                scrollTop: target.offset().top - 100
            }, 1000);
        }
    });
    
    
    $(document).on('DOMSubtreeModified', '#song-cards-container', function() {
        $('.song-card').each(function(index) {
            $(this).delay(index * 100).fadeIn(300);
        });
    });
    
    
    $(document).on('keydown', function(e) {
        if (e.ctrlKey && e.key === 'f') {
            e.preventDefault();
            $('#song-search').focus();
        }
    });
    
    
    function clearAllFilters() {
        $('#song-search').val('');
        $('#genre-filter').val('');
        $('#year-filter').val('');
        $('#language-filter').val('');
        filterSongs();
    }
    
    
    $(document).on('click', '.clear-filters', function(e) {
        e.preventDefault();
        clearAllFilters();
    });
});