jQuery(function($){
    $('.nc-caro').each(function(){
        let $wrap = $(this),
            interval = parseInt($wrap.data('interval')),
            controls = $wrap.data('controls'),
            $cards = $wrap.find('.nc-card'),
            i = 0,
            timer;

        if ($cards.length < 2) return;

        // Position cards
        $cards.css({position:'absolute',top:0,left:0,width:'100%',opacity:0});
        $wrap.css({position:'relative'});
        $cards.eq(0).css({opacity:1});
        try {
            if (window.ResizeObserver) {
                const ro = new ResizeObserver(function(){ let h = $cards.eq(i).outerHeight(); if (h && h>0) { $wrap.height(h); } });
                $cards.each(function(){ ro.observe(this); });
            }
        } catch(e) {}
        // set height to first card after layout settles
        const setH = () => { let h = $cards.eq(0).outerHeight(); if (h && h>0) { $wrap.height(h); } };
        setTimeout(setH, 0);
        $(window).on('load', setH);
        $(window).on('resize', function(){ let h = $cards.eq(i).outerHeight(); if (h && h>0) { $wrap.height(h); } });

        // Dots
        let $dots;
        if (controls === 'dots' || controls === 'both') {
            $dots = $('<div class="nc-dots"></div>');
            $cards.each(function(idx){
                $dots.append('<span class="nc-dot" data-i="'+idx+'"></span>');
            });
            $wrap.after($dots);
            $dots.find('.nc-dot').eq(0).addClass('active');
        }

        // Arrows
        if (controls === 'arrows' || controls === 'both') {
            $wrap.append('<button class="nc-arrow nc-prev">‹</button><button class="nc-arrow nc-next">›</button>');
        }

        function showSlide(n) {
            $cards.eq(i).css({opacity:0,transition:'opacity 0.6s'});
            $cards.eq(n).css({opacity:1,transition:'opacity 0.6s'});
            i = n;
            // adapt wrapper height to active card
            let targetH = $cards.eq(n).outerHeight();
            if (targetH && targetH>0) { $wrap.stop(true,true).animate({height: targetH}, 300); }

            if ($dots) {
                $dots.find('.nc-dot').removeClass('active').eq(i).addClass('active');
            }
        }

        function nextSlide() {
            let next = (i+1) % $cards.length;
            showSlide(next);
        }

        // Auto play
        timer = setInterval(nextSlide, interval);

        // Dots click
        if ($dots) {
            $dots.on('click','.nc-dot',function(){
                clearInterval(timer); // stop auto
                showSlide($(this).data('i'));
                timer = setInterval(nextSlide, interval); // restart auto
            });
        }

        // Arrows click
        $wrap.on('click','.nc-prev',function(){
            clearInterval(timer);
            let prev = (i-1+$cards.length) % $cards.length;
            showSlide(prev);
            timer = setInterval(nextSlide, interval);
        });
        $wrap.on('click','.nc-next',function(){
            clearInterval(timer);
            let next = (i+1) % $cards.length;
            showSlide(next);
            timer = setInterval(nextSlide, interval);
        });
    });

    // Read more modal
    $(document).on('click','.nc-readmore',function(){
        let id=$(this).data('id');
        $.post(nc_ajax.url,{action:'nc_load_news',id:id,nonce:nc_ajax.nonce},function(r){
	if (r.success) {
		let modal = $('<div class="nc-modal"><div class="nc-modal-content">'+r.data.html+'</div></div>');
		$('body').append(modal);
	}
        });
    });
    $(document).on('click','.nc-close',function(){$('.nc-modal').remove();});
	
	$(document).on('click','.nc-modal',function(e){
    if ($(e.target).is('.nc-modal')) {
        $('.nc-modal').remove();
    }
});
});
	